#include "global.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef DOS
#include "dos.h"
#else
#include <unistd.h>
#endif

#define PROFILE_DO_ALLOC
//#undef PROFILE_DO_ALLOC

u64 allocated=0;
u64 unique_number=0;
#ifdef PROFILE_DO_ALLOC
u64 do_alloc_calls=0;
int profile_on=0;
#endif

void * do_alloc(long n, long size)
{
void *r;

r=calloc(n,size);
while(r==NULL){
	sleep(1);
	fprintf(stderr,"Out of memory?\n");
	r=calloc(n,size);
	}
#ifdef PROFILE_DO_ALLOC
do_alloc_calls++;
allocated+=n*size;
if(profile_on)
fprintf(stderr,"do_alloc(%ld,%ld), called %ld times\n",n,size,do_alloc_calls);
#endif
return r;
}

void dump_am(void)
{
fprintf(stderr,"%ld total bytes allocated\n",allocated);
allocated=0;
}

u64  get_unique_number(void)
{
unique_number++;
return unique_number;
}
